<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Announcement;
use App\Models\Campaign;
use App\Models\Category;
use App\Models\Product;
use App\Models\Showcase;
use App\Models\Slider;
use App\Models\Story;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class HomepageController extends Controller
{
    public function index()
    {
        $with = ['getOneProductAttributes', 'getOneProductImages', 'getAllProductReviews', 'getAllProductVariants.getAllVariantAttributes'];

        $r_categories = Category::with('getAllCategoryProducts')->inRandomOrder()->get();
        $r_products = Product::with($with)->whereStatus(1)->inRandomOrder()->limit(10)->get();
        $n_products = Product::with($with)->whereStatus(1)->where('created_at', '>=', Carbon::now()->subDays(7))->limit(10)->get();
        $d_products =  Product::with($with)->whereStatus(1)->whereHas('getOneProductAttributes', function ($query) {
            $query->where('discount', '>', 0);
        })->limit(10)->get();
        $p_products = Product::with($with)->whereStatus(1)->whereHas('getAllProductReviews', function ($query) {
            $query->select('product_id')->groupBy('product_id')->havingRaw('round(avg(rating)) >= 4');
        })->limit(10)->get();
        $r_campaigns = Campaign::whereStatus(1)->inRandomOrder()->limit(6)->get();
        $sliders = Slider::get();
        $showcases = Showcase::with('getAllShowcaseAttributes.getOneShowcaseAttributeCategory')->get();
        $stories = Story::with('getAllStoryAttributes')->get();
        $announcements = Announcement::get();
        return view('web.homepage.index', [
            'r_categories' => $r_categories,
            'r_products' => $r_products,
            'n_products' => $n_products,
            'd_products' => $d_products,
            'p_products' => $p_products,
            'r_campaigns' => $r_campaigns,
            'sliders' => $sliders,
            'showcases' => $showcases,
            'stories' => $stories,
            'announcements' => $announcements
        ]);
    }
}
