<?php

namespace App\Http\Controllers\panel;

use App\Helper\Helper;
use App\Models\settings;
use App\Http\Controllers\Controller;
use App\Http\Requests\BannerUpdateRequest;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    public function update(BannerUpdateRequest $request){
        $banner = [
            'right_status'=>$request->right_status ? true : false,
            'left_status'=>$request->left_status ? true : false,
        ];
        if($request->hasFile('right')){
            $banner['right'] = Helper::imageUpload($request->right, 'storage');
        }
        if($request->hasFile('left')){
            $banner['left'] = Helper::imageUpload($request->left, 'storage');
        }
        setting($banner)->save();
        return back()->with('success', __('words.updated_action_success'));
    }

    public function updatetwo(Request $request){
        if ($request->hasFile("banner1")) {
            $banner1 = explode("/", Helper::imageUpload($request->banner1, 'banner'))[1];
        }else {
            $banner1 = settings::first()->set_bannerimg;
        }

        if ($request->hasFile("banner2")) {
            $banner2 = explode("/", Helper::imageUpload($request->banner2, 'banner'))[1];
        }else {
            $banner2 = settings::first()->set_bannerimg2;
        }
        settings::where("set_id","1")->update([
            "set_bannerimg"=>$banner1,
            "set_bannerimg2"=>$banner2
        ]);
        return back()->with('success', __('words.updated_action_success'));

    }
    
}
