<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|max:255',
            'category_id' => 'required|integer',
            'brand_id' => 'required|integer',
            'description' => 'required',
            'price' => 'required|integer',
            'discount' => 'nullable|integer',
            'seo_description'=>'required',
            'keywords'=>'required',
            'images' => 'required|array'
        ];
    }
}
