@extends('panel.layouts.extends')
@section('title')
@lang('words.banner')
@endsection
@section('content')
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <section>
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="pt-1 pb-1">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        @if ($m = Session::get('success'))
                        <div class="alert alert-success" role="alert">
                            <div class="alert-body">
                                {{ $m }}
                            </div>
                        </div>
                        @endif
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">@lang('words.banner')</h4>
                            </div>
                            <form method="POST" action="{{ route('panel.banner.update') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="logo">@lang('words.right_banner')</label>
                                                <input type="file" class="form-control" name="right">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="favicon">@lang('words.left_banner')</label>
                                                <input type="file" class="form-control" name="left">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <div class="custom-control custom-control-primary custom-switch">
                                                    <p class="mb-50">@lang('words.right_banner')</p>
                                                    <input type="checkbox" name="right_status" @if(setting('right_status')) checked @endif class="custom-control-input" id="right_status">
                                                    <label class="custom-control-label" for="right_status"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <div class="custom-control custom-control-primary custom-switch">
                                                    <p class="mb-50">@lang('words.left_banner')</p>
                                                    <input type="checkbox" name="left_status" @if(setting('left_status')) checked @endif  class="custom-control-input" id="left_status">
                                                    <label class="custom-control-label" for="left_status"></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary waves-effect waves-float waves-light mt-2 mb-2 float-right">@lang('words.save')</button>
                                </div>
                            </form>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 col-6">
                                        <h4 class="card-title">@lang('words.right_banner')</h4>
                                        <a href="javascript:void(0)">
                                            <img src="{{ asset(setting('right')) }}"
                                            class="img-fluid rounded mb-1 w-50" />
                                        </a>
                                    </div>
                                    <div class="col-md-6 col-6">
                                        <h4 class="card-title">@lang('words.left_banner')</h4>
                                        <a href="javascript:void(0)">
                                            <img src="{{ asset(setting('left')) }}"
                                            class="img-fluid rounded mb-1 w-50" />
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <hr>

                            <div class="card-body">
                                <form action="{{ route('panel.banner.updatetwo') }}" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group mb-3">
                                        <label class="form-label">
                                            Ana Sayfa Banner 1
                                        </label><br>
                                        <img style="max-width: 300px;" src="{{asset('banner')}}/{{App\Models\settings::first()->set_bannerimg}}">
                                        <input type="file" class="form-control mt-1" name="banner1">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label class="form-label">
                                            Ana Sayfa Banner 2
                                        </label><br>
                                        <img style="max-width: 300px;" src="{{asset('banner')}}/{{App\Models\settings::first()->set_bannerimg2}}">
                                        <input type="file" class="form-control mt-1" name="banner2">
                                    </div>

                                    <div class="form-group">
                                     <button type="submit" class="btn btn-primary waves-effect waves-float waves-light mt-2 mb-2 float-right">@lang('words.save')</button> 
                                 </div>

                             </form>
                         </div>

                     </div>
                 </div>
             </div>
         </section>
     </div>
 </div>
</div>
@endsection