<?php
date_default_timezone_set('Europe/Istanbul');
session_start();
include 'db-ayar.php';
$time = time();

$mail_ayar = $db->query("SELECT * FROM email_ayar LIMIT 1")->fetch(PDO::FETCH_ASSOC);
$sms_izin = $db->query("SELECT * FROM sms_izinleri LIMIT 1")->fetch(PDO::FETCH_ASSOC);

function sef($str, $options = array()){
    $str = mb_convert_encoding((string)$str, 'UTF-8', mb_list_encodings());
    $defaults = array('delimiter' => '-','limit' => null,'lowercase' => true,'replacements' => array(),'transliterate' => true);
    $options = array_merge($defaults, $options);
    $char_map = array(
        // Latin
        'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C',
        'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
        'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ő' => 'O',
        'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ű' => 'U', 'Ý' => 'Y', 'Þ' => 'TH',
        'ß' => 'ss',
        'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c',
        'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',
        'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'ő' => 'o',
        'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'ű' => 'u', 'ý' => 'y', 'þ' => 'th',
        'ÿ' => 'y',
        // Latin symbols
        '©' => '(c)',
        // Greek
        'Α' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'H', 'Θ' => '8',
        'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M', 'Ν' => 'N', 'Ξ' => '3', 'Ο' => 'O', 'Π' => 'P',
        'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F', 'Χ' => 'X', 'Ψ' => 'PS', 'Ω' => 'W',
        'Ά' => 'A', 'Έ' => 'E', 'Ί' => 'I', 'Ό' => 'O', 'Ύ' => 'Y', 'Ή' => 'H', 'Ώ' => 'W', 'Ϊ' => 'I',
        'Ϋ' => 'Y',
        'α' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'h', 'θ' => '8',
        'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => '3', 'ο' => 'o', 'π' => 'p',
        'ρ' => 'r', 'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'x', 'ψ' => 'ps', 'ω' => 'w',
        'ά' => 'a', 'έ' => 'e', 'ί' => 'i', 'ό' => 'o', 'ύ' => 'y', 'ή' => 'h', 'ώ' => 'w', 'ς' => 's',
        'ϊ' => 'i', 'ΰ' => 'y', 'ϋ' => 'y', 'ΐ' => 'i',
        // Turkish
        'Ş' => 'S', 'İ' => 'I', 'Ç' => 'C', 'Ü' => 'U', 'Ö' => 'O', 'Ğ' => 'G',
        'ş' => 's', 'ı' => 'i', 'ç' => 'c', 'ü' => 'u', 'ö' => 'o', 'ğ' => 'g',
        // Russian
        'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'Yo', 'Ж' => 'Zh',
        'З' => 'Z', 'И' => 'I', 'Й' => 'J', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O',
        'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C',
        'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sh', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'Yu',
        'Я' => 'Ya',
        'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh',
        'з' => 'z', 'и' => 'i', 'й' => 'j', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o',
        'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c',
        'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sh', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu',
        'я' => 'ya',
        // Ukrainian
        'Є' => 'Ye', 'І' => 'I', 'Ї' => 'Yi', 'Ґ' => 'G',
        'є' => 'ye', 'і' => 'i', 'ї' => 'yi', 'ґ' => 'g',
        // Czech
        'Č' => 'C', 'Ď' => 'D', 'Ě' => 'E', 'Ň' => 'N', 'Ř' => 'R', 'Š' => 'S', 'Ť' => 'T', 'Ů' => 'U',
        'Ž' => 'Z',
        'č' => 'c', 'ď' => 'd', 'ě' => 'e', 'ň' => 'n', 'ř' => 'r', 'š' => 's', 'ť' => 't', 'ů' => 'u',
        'ž' => 'z',
        // Polish
        'Ą' => 'A', 'Ć' => 'C', 'Ę' => 'e', 'Ł' => 'L', 'Ń' => 'N', 'Ó' => 'o', 'Ś' => 'S', 'Ź' => 'Z',
        'Ż' => 'Z',
        'ą' => 'a', 'ć' => 'c', 'ę' => 'e', 'ł' => 'l', 'ń' => 'n', 'ó' => 'o', 'ś' => 's', 'ź' => 'z',
        'ż' => 'z',
        // Latvian
        'Ā' => 'A', 'Č' => 'C', 'Ē' => 'E', 'Ģ' => 'G', 'Ī' => 'i', 'Ķ' => 'k', 'Ļ' => 'L', 'Ņ' => 'N',
        'Š' => 'S', 'Ū' => 'u', 'Ž' => 'Z',
        'ā' => 'a', 'č' => 'c', 'ē' => 'e', 'ģ' => 'g', 'ī' => 'i', 'ķ' => 'k', 'ļ' => 'l', 'ņ' => 'n',
        'š' => 's', 'ū' => 'u', 'ž' => 'z'
    );
    $str = preg_replace(array_keys($options['replacements']), $options['replacements'], $str);
    if ($options['transliterate']) {
        $str = str_replace(array_keys($char_map), $char_map, $str);
    }
    $str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
    $str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
    $str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
    $str = trim($str, $options['delimiter']);
    return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
}

function cleanAZ($s) {
  $s = preg_replace('/([^a-zA-Z0-9-_]*)/i', '', $s);
  return $s;
}

function clean_string($s) {
    if ( is_array($s) ) {
        foreach ($s as $s_key=>$s_val) {
            $s[$s_key] = clean_string($s_val);
        }
    } else {
        if (
            ( function_exists("get_magic_quotes_gpc"))
            ||
            ( ini_get('magic_quotes_sybase') && strtolower(ini_get('magic_quotes_sybase'))!='off' )
        ) {
            $s = stripslashes($s);
        }
    }
    
    return $s;
}


function clean($s) {
    $s = is_array($s) ? array_map('clean', $s) : clean_string($s);
    return $s;
}

function parseJsonArray($jsonArray, $parentID = 0) {
  $return = array();
  foreach ($jsonArray as $subArray) {
    $returnSubSubArray = array();
    if (isset($subArray->children)) {
      $returnSubSubArray = parseJsonArray($subArray->children, $subArray->id);
    }
    $return[] = array('id' => $subArray->id, 'parentID' => $parentID);
    $return = array_merge($return, $returnSubSubArray);
  }
  return $return;
}


function Sayfala($top_sayfa,$page,$limit,$page_url){
    // Sayfalama Şeridimiz

    if ($top_sayfa > $limit) :


    $x = 5; // Aktif sayfadan önceki/sonraki sayfa gösterim sayisi
    $lastP = ceil($top_sayfa / $limit);

    // sayfa 1'i yazdir
    if ($page==1){
        echo '<li class="page-item active">
                <a class="page-link" href="#">1</a>
            </li>';
    }else{
        echo '<li class="page-item">
                <a class="page-link" href="'.$page_url.'1">1</a>
            </li>';
    }

    // "..." veya direkt 2
    if ($page-$x>2){
        echo '<li class="page-item">
                <a class="page-link" href="#">...</a>
            </li>';
        $i = $page-$x;
    }else{
        $i = 2;
    }
    // +/- $x sayfalari yazdir
    for ($i; $i<=$page+$x; $i++){
        if ($i==$page)
        echo '<li class="page-item active">
                <a class="page-link" href="#">'.$i.'</a>
            </li>';
        else
        echo '<li class="page-item">
                <a class="page-link" href="'.$page_url.''.$i.'">'.$i.'</a>
            </li>';
        if ($i==$lastP)
        break;
    }

    // "..." veya son sayfa
    if ($page+$x<$lastP-1){
        echo '<li class="page-item">
                <a class="page-link" href="#">...</a>
            </li>';
        echo '<li class="page-item">
                <a class="page-link" href="'.$page_url.''.$lastP.'">'.$lastP.'</a>
            </li>';
    }elseif ($page+$x==$lastP-1){
        echo '<li class="page-item">
                <a class="page-link" href="'.$page_url.''.$lastP.'">'.$lastP.'</a>
            </li>';
    }
    endif;
}


function alt_kategori_bul($x){
    global $db;
    $query = $db->query("SELECT * FROM kategori WHERE ust_kategori = '{$x}' ORDER BY sira ASC", PDO::FETCH_ASSOC);
    if($query->rowCount()){
        $kataegori_idleri = $x.',';
        foreach($query as $row){
          $kataegori_idleri .= alt_kategori_bul($row['id']);
        }
    }else{
      $kataegori_idleri = $x.',';
    }
    return $kataegori_idleri;
}

function fiyat($deger){
    if ( strpos($deger,",") ) {
        $deger = str_replace(",", ".", $deger);
        $deger = trim(dbtrim($deger));
    }
    return number_format($deger, 2, ',', '.');
}


$siparis_durum[0] = 'Onay Bekliyor';
$siparis_durum[1] = 'Odeme Bekleniyor';
$siparis_durum[2] = 'Odeme Alındı';
$siparis_durum[3] = 'Onaylandı';
$siparis_durum[4] = 'Kargoda';
$siparis_durum[5] = 'Tamamlandı';
$siparis_durum[6] = 'İptal Edildi';




$yorum_durum[0] = 'Onay Bekliyor';
$yorum_durum[1] = 'Onaylandı';
$yorum_durum[2] = 'İptal Edildi';


$odeme_yontemi[1] = 'Online Kredi Kartı';
$odeme_yontemi[2] = 'Kapıda Kredi Kartı';
$odeme_yontemi[3] = 'Kapıda Nakit';
$odeme_yontemi[4] = 'Banka Havalesi';


$kredi_karti_odendi[0] = '<b style="color:red">Kredi Kartı Ödemesi Yapılmadı</b>';
$kredi_karti_odendi[1] = '<b style="color:green">Kredi Kartı Ödemesi Yapıldı</b>';

foreach($_GET    as $k => $v) $_GET[$k]    = clean($v);
foreach($_POST   as $k => $v) $_POST[$k]   = clean($v);

function sms($text,$numara){
    global $db;
    $sms_ayari = $db->query("SELECT * FROM netgsm_ayari LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if(!empty($sms_ayari['username']) AND !empty($sms_ayari['password'])){
        try {
            $client = new SoapClient("http://soap.netgsm.com.tr:8080/Sms_webservis/SMS?wsdl");
            $msg  = $text;
            $gsm  = array('9'.$numara);

            $Result = $client -> smsGonder1NV2(array('username'=>$sms_ayari['username'], 'password' => $sms_ayari['password'], 'header' => $sms_ayari['username'], 'msg' => $msg, 'gsm' => $gsm,  'filter' => '', 'startdate'  => '', 'stopdate'  => '', 'encoding' => ''  ));

        } catch (Exception $exc){
         echo "Soap Hatasi Olustu: " . $exc->getMessage();
        }
    }
}

function idval( $num=0, $greaterthan=0 ) {
    if ( !is_numeric($greaterthan) ) {
		$greaterthan = 0;
	}
    return ( intval($num) > $greaterthan && is_numeric($num) ? (intval($num)==0?"0":intval($num)) : "0" );
}

function dbtrim($par) {
    return str_replace(array("'","\""), array("'","&quot;"), $par);
}

function dbuntrim($par) {
    return str_replace(array("'","&quot;"), array("'","\""), $par);
}

function dbexport($x='') {
	return var_export($x, true);
}

function create_randString($length=11) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function create_randInt($length=11) {
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function temizle($t) {
	$t = str_replace("from", "", $t);
	$t = str_replace("where", "", $t);
	$t = str_replace("concat", "", $t);
	$t = str_replace("limit", "", $t);
	$t = str_replace("'", "", $t);
	$t = str_replace("char", "", $t);
	$t = str_replace("select", "", $t);
	$t = str_replace("insert", "", $t);
	$t = str_replace("delete", "", $t);
	$t = str_replace("update", "", $t);
	$t = str_replace("drop table", "", $t);
	$t = str_replace("union", "", $t);
	$t = str_replace("null", "", $t);
	$t = str_replace("SELECT", "", $t);
	$t = str_replace("INSERT", "", $t);
	$t = str_replace("DELETE", "", $t);
	$t = str_replace("UPDATE", "", $t);
	$t = str_replace("DROP TABLE", "", $t);
	$t = str_replace("UNION", "", $t);
	$t = str_replace("NULL", "", $t);
	$t = str_replace("order by", "", $t);
	$t = str_replace(";", "", $t);
	$t = str_replace("exec", "", $t);
	$t = str_replace("shell", "", $t);
	$t = str_replace("cmd", "", $t);
	$text = dbtrim($t);
	return $text;
}

function get($q) {
	if ( !empty($_GET[$q]) ) {
		$data = temizle($_GET[$q]);
	} else {
		$data = false;
	}
	return $data;
}

function post($q) {
	if ( !empty($_POST[$q]) ) {
		$data = temizle($_POST[$q]);
	} else {
		$data = '';
	}
	return $data;
}


$kupon_indirim_turu[1] = '%';
$kupon_indirim_turu[2] = '-';
?>