if (!window.Mage) var Mage = {};

Mage.Cookies = {};
Mage.Cookies.expires = null;
Mage.Cookies.path = '/';
Mage.Cookies.domain = null;
Mage.Cookies.secure = false;
Mage.Cookies.set = function(name, value) {
    var argv = arguments;
    var argc = arguments.length;
    var expires = (argc > 2) ? argv[2] : Mage.Cookies.expires;
    var path = (argc > 3) ? argv[3] : Mage.Cookies.path;
    var domain = (argc > 4) ? argv[4] : Mage.Cookies.domain;
    var secure = (argc > 5) ? argv[5] : Mage.Cookies.secure;
    document.cookie = name + "=" + escape(value) +
        ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
        ((path == null) ? "" : ("; path=" + path)) +
        ((domain == null) ? "" : ("; domain=" + domain)) +
        ((secure == true) ? "; secure" : "");
};

Mage.Cookies.get = function(name) {
    var arg = name + "=";
    var alen = arg.length;
    var clen = document.cookie.length;
    var i = 0;
    var j = 0;
    while (i < clen) {
        j = i + alen;
        if (document.cookie.substring(i, j) == arg)
            return Mage.Cookies.getCookieVal(j);
        i = document.cookie.indexOf(" ", i) + 1;
        if (i == 0)
            break;
    }
    return null;
};

Mage.Cookies.clear = function(name) {
    if (Mage.Cookies.get(name)) {
        document.cookie = name + "=" +
            "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    }
};

Mage.Cookies.getCookieVal = function(offset) {
    var endstr = document.cookie.indexOf(";", offset);
    if (endstr == -1) {
        endstr = document.cookie.length;
    }
    return unescape(document.cookie.substring(offset, endstr));
};