<?php

require_once 'Database.php';
require_once 'Brand.php';
require_once 'Helper.php';

class XmlIntegration
{
    private $id;
    private $database;
    private $name;
    private $url;
    private $last_product_updated;
    private $properties;
    private $property_mapping;
    private $rules;
    private $categories;
    private $category_mapping;
    private $is_active;
    private $updated_at;
    private $xml;
    private $xmlProducts;
    private $que;
    private $created_at;
    private $brands;

    public function __construct()
    {
        $this->database = Database::getInstance();
    }

    /**
     * @param $id integer
     * @return XmlIntegration
     */
    public function get($id)
    {
        $integration = $this->database->query('SELECT * FROM xml_integrations WHERE id='.$id)->fetch(PDO::FETCH_OBJ);

        $this->id = $integration->id;
        $this->name = $integration->name;
        $this->url = $integration->url;
        $this->last_product_updated = $integration->last_product_updated;
        $this->property_mapping = unserialize($integration->property_mapping);
        $this->rules = unserialize($integration->rules);
        $this->category_mapping = unserialize($integration->category_mapping);
        $this->is_active = $integration->is_active;
        $this->updated_at = $integration->updated_at;
        $this->created_at = $integration->created_at;
        $this->que = $integration->que;
        $this->properties = unserialize($integration->properties);
        $this->categories = unserialize($integration->categories);

        $brand = new Brand();

        foreach ($brand->getAll() as $key => $brandDetail) {
            $this->brands[$brandDetail['baslik']] = $brandDetail['id'];
        }

        return $this;
    }

    /**
     * @return array
     */
    public function getAll()
    {
        $integrations = [];

        $integrations = $this->database->query('SELECT * FROM xml_integrations')->fetchAll(PDO::FETCH_OBJ);


        if ($integrations) {
            foreach ($integrations as $key => $integration) {
                $integrations[$key]->productCount = $this->database->query('SELECT count(*) FROM urunler WHERE xml='.$integration->id)->fetchColumn();
            }
        }

        return $integrations;
    }

    /**
     * @param $params array
     * @return integer
     */
    public function add($params)
    {
        $data = $fields = [];
        $id = 0;

        foreach ($params as $key => $value) {
            $fields[] = $key;
            $data[':' . $key] = $value;
        }

        $insert = $this->database->prepare('INSERT INTO xml_integrations (' . implode(', ', $fields) . ') VALUES (:' . implode(', :', $fields) . ')');
        $saved = $insert->execute($data);

        if ($saved) {
            $id = $this->database->lastInsertId();
        }

        return $id;
    }

    /**
     * @param $updateParameters array
     * @return boolean
     * @throws Exception
     */
    public function update($updateParameters) {

        $updated = false;

        if (!empty($updateParameters)) {

            $data = $field = [];

            foreach ($updateParameters as $key => $params) {
                $field[] = $key . '=:' . $key;
                $data[':'. $key] = $params;
            }

            $update = $this->database->prepare('UPDATE xml_integrations SET ' . implode(', ', $field) . ' WHERE id=:id');
            $updated = $update->execute($data);

            if (!$updated) {
                throw new \Exception('Güncelleme başarısız');
            }
        }

        return $updated;
    }

    /**
     * @param array $param
     * @return array
     * @throws Exception
     */
    public function filter($param)
    {
        if (!is_array($param)) {
            throw new \Exception('Parametre array değil');
        }

        $where = $filteredCampaigns = [];

        foreach ($param as $key => $value) {
            if (is_array($value)) {
                $where[] = $key . ' IN (' . implode(', ', $value) . ')';
            } elseif($key == 'specific') {
                $where[] = $value;
            } else {
                $where[] = $key . '=' . $value;
            }
        }

        return $this->database->query('SELECT * FROM xml_integrations WHERE ' . implode(' AND ', $where))->fetchAll(PDO::FETCH_OBJ);
    }

    /**
     * @param null $url
     * @throws Exception
     */
    public function getXML ($url = null) {

        if ($url) {
            $this->url = $url;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $xml = curl_exec($ch);
        curl_close($ch);
        $this->xml = simplexml_load_string($xml);
        $this->xmlProducts();
    }

    /**
     * @throws Exception
     */

    public function xmlProducts () {

        if (empty($this->properties) || empty(($this->categories))) {
            $properties = $categories = null;
            foreach ($this->xml->urun as $key => $urun) {
                foreach ($urun as $property => $detail) {

                    $properties[$property] = true;
                    $categories[(string) $urun->anakategori][(string) $urun->kategori][(string) $urun->altkategori] = true;

                }
            }

            $this->update([
                'id' => $this->id,
                'properties' => serialize($properties),
                'categories' => serialize($categories),
                'que' => 0
            ]);

            $this->setQue(0);
            $this->setProperties($properties);
            $this->setCategories($categories);

            throw new Exception('Yeni XML : Lütfen "XML ÖZELLİK ve KATEGORİ EŞLEŞTİRME" işlemi yapınız.');

        } else {
            if (empty($this->property_mapping)) {
                throw new Exception('Lütfen "XML ÖZELLİK ->YEREL ÖZELLİK EŞLEŞTİRME" işlemi yapınız.');
            } elseif (empty($this->category_mapping)) {
                throw new Exception('Lütfen "XML KATEGORİ -> YEREL KATEGORİ EŞLEŞTİRME" işlemi yapınız.');
            } else {

                $helper = new Helper();

                foreach ($this->xml->urun as $key => $urun) {
                    $product = $this->decorate($urun); unset($product['']);
                    $control = null;
                    if ($product['barcode']['value']) {
                        $control = $this->database->query('SELECT urunid FROM urunler WHERE barcode="'.$product['barcode']['value']. '" AND xml='. $this->getId())->fetchColumn();
                    }

                    $outputProduct = $images = [];

                    foreach ($product as $key => $value) {
                        if ($control) {
                            foreach ($this->rules['updatedProperty'] as $property => $active) {
                                if ($value['property'] == $property ) {
                                    $outputProduct[$key] = $value['value'];
                                }
                            }

                            $outputProduct['urunid'] = $control;

                            if ($key == 'kategori') {
                                $outputProduct['kategori'] = $value['value'];
                            }

                            if ($key == 'altkategori') {
                                $outputProduct['altkategori'] = $value['value'];
                            }

                        } else {
                            if ($key == 'resim') {
                                $images['image']['main_image'] = $value['value'];
                                $images['barcode'] = $product['barcode']['value'];
                                $images['xml'] = $this->getId();
                            } elseif (@preg_match('/galeri_image/', $key)) {
                                $images['image']['galeri_images'][] = $value['value'];
                                $images['barcode'] = $product['barcode']['value'];
                                $images['xml'] = $this->getId();
                            } elseif ($key == 'urunMarkasi') {
                                $outputProduct[$key] = $this->brands[$value['value']];
                            } else {
                                $outputProduct[$key] = $value['value'];
                            }
                        }
                   }

                    if ($control) {
                        $this->productUpdate($outputProduct);
                    } else {
                        $outputProduct['durum'] = 1;
                        $outputProduct['xml'] = $this->getId();
                        $outputProduct['seo'] = $images['urunAdi'] = $helper->link($outputProduct['urunAdi'] . '-' .$outputProduct['barcode']);
                        $this->productAdd($outputProduct);
                        $this->addImageQue(['data' => serialize($images)]);
                    }
                }
            }
        }
    }

    public function decorate($xmlProduct) {

        $baseProduct = [];

        foreach ($xmlProduct as $property => $detail) {
            if (!empty((string) $property)) {
                $baseProduct[$this->getPropertyMapping()[(string) $property]]['value'] = (string) $detail;
                $baseProduct[$this->getPropertyMapping()[(string) $property]]['property'] = (string) $property;
            }
        }

        if ( (string) $xmlProduct->anakategori) {
            $baseProduct['kategori']['value'] = $this->category_mapping[ (string) $xmlProduct->anakategori]["main"];
        }

        if ( (string) $xmlProduct->kategori) {
            $baseProduct['altkategori']['value'] = $this->category_mapping[ (string) $xmlProduct->anakategori]["sub"][ (string) $xmlProduct->kategori]["main"];
        }

        if ( (string) $xmlProduct->altkategori) {
            $baseProduct['altkategori']['value'] = $this->category_mapping[ (string) $xmlProduct->anakategori]["sub"][ (string) $xmlProduct->kategori]["sub"][ (string) $xmlProduct->altkategori];
        }

        return $baseProduct;

    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return mixed
     */
    public function getLastProductUpdated()
    {
        return $this->last_product_updated;
    }

    /**
     * @param mixed $last_product_updated
     */
    public function setLastProductUpdated($last_product_updated)
    {
        $this->last_product_updated = $last_product_updated;
    }

    /**
     * @return mixed
     */
    public function getPropertyMapping()
    {
        return $this->property_mapping;
    }

    /**
     * @param mixed $property_mapping
     */
    public function setPropertyMapping($property_mapping)
    {
        $this->property_mapping = $property_mapping;
    }

    /**
     * @return mixed
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * @param mixed $rules
     */
    public function setRules($rules)
    {
        $this->rules = $rules;
    }

    /**
     * @return mixed
     */
    public function getCategoryMapping()
    {
        return $this->category_mapping;
    }

    /**
     * @param mixed $category_mapping
     */
    public function setCategoryMapping($category_mapping)
    {
        $this->category_mapping = $category_mapping;
    }

    /**
     * @return mixed
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * @param mixed $is_active
     */
    public function setIsActive($is_active)
    {
        $this->is_active = $is_active;
    }

    /**
     * @return mixed
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }

    /**
     * @param mixed $updated_at
     */
    public function setUpdatedAt($updated_at)
    {
        $this->updated_at = $updated_at;
    }

    /**
     * @return mixed
     */
    public function getXmlProducts()
    {
        return $this->xmlProducts;
    }

    /**
     * @param mixed $xmlProducts
     */
    public function setXmlProducts($xmlProducts)
    {
        $this->xmlProducts = $xmlProducts;
    }

    /**
     * @return mixed
     */
    public function getQue()
    {
        return $this->que;
    }

    /**
     * @param mixed $que
     */
    public function setQue($que)
    {
        $this->que = $que;
    }

    /**
     * @return mixed
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @param mixed $properties
     */
    public function setProperties($properties)
    {
        $this->properties = $properties;
    }

    /**
     * @return mixed
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @param mixed $categories
     */
    public function setCategories($categories)
    {
        $this->categories = $categories;
    }

    /**
     * @return mixed
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }

    /**
     * @param mixed $created_at
     */
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
    }

    public function productAdd($params)
    {
        $data = $fields = [];

        $id = 0;

        foreach ($params as $key => $value) {
            $fields[] = $key;
            $data[':' . $key] = $value;
        }

        $insert = $this->database->prepare('INSERT INTO urunler (' . implode(', ', $fields) . ') VALUES (:' . implode(', :', $fields) . ')');
        $saved = $insert->execute($data);

        if ($saved) {
            $id = $this->database->lastInsertId();
        }

        return $id;
    }

    public function addImageQue($params)
    {
        $data = $fields = [];

        $id = 0;

        foreach ($params as $key => $value) {
            $fields[] = $key;
            $data[':' . $key] = $value;
        }

        $insert = $this->database->prepare('INSERT INTO xml_images (' . implode(', ', $fields) . ') VALUES (:' . implode(', :', $fields) . ')');
        $saved = $insert->execute($data);

        if ($saved) {
            $id = $this->database->lastInsertId();
        }

        return $id;
    }

    /**
     * @param $updateParameters array
     * @return boolean
     * @throws Exception
     */
    public function productUpdate($updateParameters) {

        $updated = false;

        if (!empty($updateParameters)) {

            $data = $field = [];

            foreach ($updateParameters as $key => $params) {
                $field[] = $key . '=:' . $key;
                $data[':'. $key] = $params;
            }

            $update = $this->database->prepare('UPDATE urunler SET ' . implode(', ', $field) . ' WHERE urunid=:urunid');
            $updated = $update->execute($data);
        }

        return $updated;
    }


}